//------------------------------------------------------------------------------
// Lab. 09: Design state feedback controller for a given system to achieve desired dynamic characteristics.
//              scilab - 5.5.1
//              Operating System : Windows 7, 32-bit
//*****************************************************************************
//Clean the environment
close;
clear;
clc;

// State space representation
A=[0 1;-0.16 -1.5];
B=[0 1]';
C=[0 1];
D=0;

sys1=syslin('d',A,B,C,D)

// Desired poles
Pd=[0.5+0.5*%i 0.5-0.5*%i];

// State feedback gain matrix
K=ppol(A,B,Pd)
mprintf('State feedback gain matrix is K=') 
disp(K)

//Closed loop system
sys=syslin('d',A-B*K,B,C,D)

// Sampling Time
Ts=0.5;
t=0:Ts:14;
u=ones(1,length(t));

//Response of open loop system
y1=flts(u,sys1);
plot2d2(t,y1,2)
xgrid(35)
title('Response of open loop system','fontsize',3)
xlabel('kT','fontsize',2)
ylabel('y(kT)','fontsize',2)

//Response of closed loop system
y=flts(u,sys);
figure,
plot2d2(t,y,2)
f=get("current_figure") //Current figure handle                
f.background=8
xgrid(36)
title('Response of closed loop system','fontsize',3)
xlabel('kT','fontsize',2)
ylabel('y(kT)','fontsize',2)


